/*
 * Decompiled with CFR 0.152.
 */
package com.genpyon.mc.Utilities;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.Vector;

public class ItemUtils {
    public static boolean containsLore(ItemStack ItemStack2, String LoreText) {
        if (ItemStack2.getItemMeta() == null || !ItemStack2.getItemMeta().hasLore()) {
            return false;
        }
        List list = ItemStack2.getItemMeta().getLore();
        return list.contains(LoreText);
    }

    public static void dropItemStack(Location loc, ItemStack is) {
        Location spawn = loc.clone();
        spawn.setX(spawn.getX() - 0.5);
        spawn.setY(spawn.getY() - 0.5);
        spawn.setZ(spawn.getZ() - 0.5);
        Item item = loc.getWorld().dropItemNaturally(spawn, is);
        item.setVelocity(item.getVelocity().zero());
        item.setFallDistance(0.0f);
        if (item.getCustomName() != null) {
            item.setCustomNameVisible(true);
        }
    }

    public static void dropItemStack(Location loc, ItemStack is, Vector vel, int falldistance) {
        Location spawn = loc.clone();
        spawn.setX(spawn.getX() - 0.5);
        spawn.setY(spawn.getY() - 0.5);
        spawn.setZ(spawn.getZ() - 0.5);
        Item item = loc.getWorld().dropItemNaturally(spawn, is);
        item.setVelocity(vel);
        item.setFallDistance((float)falldistance);
    }

    public static ItemStack metaItemStack(Material material, int am, String name, String ... list) {
        List<String> lore = Arrays.asList(list);
        return ItemUtils.metaItemStack(material, am, name, lore);
    }

    public static ItemStack metaItemStack(Material material, int am, String name, List<String> list) {
        ItemStack item = new ItemStack(material, am);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(list);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack metaItemStack(Material material, int am, Enchantment enc, int Lv, String name, List<String> list) {
        ItemStack item = ItemUtils.metaItemStack(material, am, name, list);
        if (enc != null) {
            ItemMeta im = item.getItemMeta();
            im.addEnchant(enc, Lv, false);
            item.setItemMeta(im);
        }
        return item;
    }

    public static ItemStack metaItemStack(Material material, int am, Enchantment enc, int Lv, String name, String ... list) {
        List<String> lore = Arrays.asList(list);
        return ItemUtils.metaItemStack(material, am, enc, Lv, name, lore);
    }

    public static ItemStack setCustomModelData(ItemStack is, int i) {
        ItemMeta im = is.getItemMeta();
        im.setCustomModelData(Integer.valueOf(i));
        is.setItemMeta(im);
        return is;
    }

    public static ItemStack createBookEnchant(int am, Enchantment ench, int enchlv, String name, String ... list) {
        List<String> lore = Arrays.asList(list);
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK, am);
        EnchantmentStorageMeta bookmeta = (EnchantmentStorageMeta)book.getItemMeta();
        bookmeta.addStoredEnchant(ench, enchlv, true);
        if (!name.equals(null)) {
            bookmeta.setDisplayName(name);
        }
        bookmeta.setLore(lore);
        book.setItemMeta((ItemMeta)bookmeta);
        return book;
    }

    public static void setHeadSkin(String playerName, Player a) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setOwner(playerName);
        skull.setItemMeta((ItemMeta)meta);
        a.getInventory().addItem(new ItemStack[]{skull});
    }

    public static ItemStack createPlayerSkullMeta(String UserName, int am, Enchantment enc, int Lv, String ItemName, List<String> list) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD, am);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setOwner(UserName);
        if (enc != null) {
            meta.addEnchant(enc, Lv, false);
        }
        meta.setDisplayName(ItemName);
        List<String> lore = list;
        meta.setLore(lore);
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    public static ItemStack createPlayerSkullMeta(String UserName, int am, String ItemName, List<String> list) {
        ItemStack skull = ItemUtils.createPlayerSkullMeta(UserName, am, null, 0, ItemName, list);
        return skull;
    }

    public static ItemStack createPlayerSkullMeta(String UserName, int am, String ItemName, String ... list) {
        List<String> lore = Arrays.asList(list);
        ItemStack skull = ItemUtils.createPlayerSkullMeta(UserName, am, null, 0, ItemName, lore);
        return skull;
    }

    public static ItemStack createPlayerSkullMeta(String UserName, int am, Enchantment enc, int Lv, String ItemName, String ... list) {
        List<String> lore = Arrays.asList(list);
        ItemStack skull = ItemUtils.createPlayerSkullMeta(UserName, am, enc, Lv, ItemName, lore);
        return skull;
    }

    public static boolean checkFullInventory(Inventory inv) {
        boolean bool = true;
        int i = 0;
        while (i < 36) {
            if (inv.getItem(i) == null) {
                bool = false;
                i = inv.getSize();
            }
            ++i;
        }
        return bool;
    }

    public static Inventory createInventory(int size, String invName) {
        return Bukkit.createInventory(null, (int)size, (String)invName);
    }
}

