/*
 * Decompiled with CFR 0.152.
 */
package com.genpyon.mc.Utilities;

import com.genpyon.mc.Main;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Utils {
    static SecureRandom rnd = new SecureRandom();

    public static float getUserDistance(Location sender, Location target) {
        return (float)sender.distance(target);
    }

    public static String getUserDistanceString(Player basePlayer, Player targetPlayer) {
        float distance = Utils.getUserDistance(basePlayer.getLocation(), targetPlayer.getLocation());
        return String.format("%.1f", Float.valueOf(distance));
    }

    public static String formatStringComma(Long num) {
        return String.format("%,d", num);
    }

    public static String formatStringComma(int num) {
        return String.format("%,d", num);
    }

    public static String kblong(Long in) {
        in = in / 1000L;
        return Utils.formatStringComma((long)in);
    }

    public static String kblong(int in) {
        return Utils.formatStringComma(in /= 1000);
    }

    public static void sendLogger(String msg) {
        Bukkit.getLogger().info(msg);
    }

    public static void sendPlayer(Player p, String msg, boolean logger) {
        p.sendMessage(msg);
        if (logger) {
            Bukkit.getLogger().info(String.valueOf(p.getName()) + "->" + msg);
        }
    }

    public static void sendPlayer(Player p, String msg) {
        p.sendMessage(msg);
    }

    public static void sendPlayerDelay(final Player p, final String msg, Long later) {
        new BukkitRunnable(){

            public void run() {
                p.sendMessage(msg);
            }
        }.runTaskLater((Plugin)Main.getInstance(), later.longValue());
    }

    public static void broadcastMessage(String Message) {
        for (Player a : Bukkit.getOnlinePlayers()) {
            Utils.sendPlayer(a, Message);
        }
        Utils.sendLogger(Message);
    }

    public static boolean equalsMaterial(Location loc, double x, double y, double z, Material mat) {
        Location locs = loc.clone();
        locs.setX(x);
        locs.setY(y);
        locs.setZ(z);
        if (locs.getBlock() == null || locs.getBlock().isEmpty()) {
            return false;
        }
        return locs.getBlock().getType().equals((Object)mat);
    }

    public static boolean equalsMaterialEmpty(Location loc, double x, double y, double z) {
        Location locs = loc.clone();
        locs.setX(x);
        locs.setY(y);
        locs.setZ(z);
        return locs.getBlock() == null || locs.getBlock().isEmpty();
    }

    public static void LocationTeleport(Player p, Location loc, boolean Spawn, boolean getUserPitch) {
        Location location = loc.clone();
        if (getUserPitch) {
            location.setYaw(p.getLocation().getYaw());
            location.setPitch(p.getLocation().getPitch());
        }
        if (Spawn) {
            p.setRespawnLocation(loc, true);
        }
        p.teleport(location);
        Utils.soundToPlayer(p, Sound.ENTITY_ENDERMAN_TELEPORT);
    }

    public static void worldTeleport(String worldName, Player p, Boolean Spawn) {
        WorldCreator worldcreator = new WorldCreator(worldName);
        World world = worldcreator.createWorld();
        Location loc = p.getLocation();
        loc.setYaw(p.getLocation().getYaw());
        loc.setPitch(p.getLocation().getPitch());
        p.teleport(world.getSpawnLocation());
        if (Spawn.booleanValue()) {
            p.setRespawnLocation(world.getSpawnLocation(), true);
        }
        Utils.soundToPlayer(p, Sound.ENTITY_ENDERMAN_TELEPORT);
    }

    public static Location configLocation(String xyz, boolean pitchYaw) {
        double x = Main.getInstance().getConfig().getDouble(String.valueOf(xyz) + ".x");
        double y = Main.getInstance().getConfig().getDouble(String.valueOf(xyz) + ".y");
        double z = Main.getInstance().getConfig().getDouble(String.valueOf(xyz) + ".z");
        String worldname = Main.getInstance().getConfig().getString(String.valueOf(xyz) + ".world");
        World world = Bukkit.getWorld((String)worldname);
        Location loc = new Location(world, x, y, z);
        if (pitchYaw) {
            float pitch = (float)Main.getInstance().getConfig().getDouble(String.valueOf(xyz) + ".pitch");
            float yaw = (float)Main.getInstance().getConfig().getDouble(String.valueOf(xyz) + ".yaw");
            loc.setPitch(pitch);
            loc.setYaw(yaw);
        }
        return loc;
    }

    public static Location configLocation(String xyz) {
        return Utils.configLocation(xyz, false);
    }

    public static void setConfigLocaiton(String LocationName, Location loc, String memo) {
        Main.getInstance().getConfig().set(String.valueOf(LocationName) + ".x", (Object)((double)loc.getBlockX() + 0.5));
        Main.getInstance().getConfig().set(String.valueOf(LocationName) + ".y", (Object)((double)loc.getBlockY() + 0.5));
        Main.getInstance().getConfig().set(String.valueOf(LocationName) + ".z", (Object)((double)loc.getBlockZ() + 0.5));
        Main.getInstance().getConfig().set(String.valueOf(LocationName) + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        Main.getInstance().getConfig().set(String.valueOf(LocationName) + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        Main.getInstance().getConfig().set(String.valueOf(LocationName) + ".world", (Object)loc.getWorld().getName());
        if (memo != null) {
            Main.getInstance().getConfig().set(String.valueOf(LocationName) + ".memo", (Object)memo);
        }
        Main.getInstance().saveConfig();
        Main.getInstance().reloadConfig();
    }

    public static void setConfigLocaiton(String LocationName, Location loc) {
        Utils.setConfigLocaiton(LocationName, loc, null);
    }

    public static List<Location> getYamlLocations(FileConfiguration yaml, String args) {
        ArrayList<Location> list = new ArrayList<Location>();
        int i = 1;
        while (i < 100) {
            if (yaml.contains(String.valueOf(args) + i)) {
                Location loc = yaml.getLocation(String.valueOf(args) + i);
                list.add(loc);
                Utils.sendLogger(String.valueOf(args) + i + " \u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002");
            } else {
                i = 100;
            }
            ++i;
        }
        return list;
    }

    public static Location getYmlLocation(FileConfiguration ymlFiles, String xyz, boolean pitch) {
        double x = ymlFiles.getDouble(String.valueOf(xyz) + ".x");
        double y = ymlFiles.getDouble(String.valueOf(xyz) + ".y");
        double z = ymlFiles.getDouble(String.valueOf(xyz) + ".z");
        String worldname = ymlFiles.getString(String.valueOf(xyz) + ".world");
        World world = Bukkit.getWorld((String)worldname);
        Location loc = new Location(world, x, y, z);
        if (pitch) {
            float pitchs = (float)ymlFiles.getDouble(String.valueOf(xyz) + ".pitch");
            float yaw = (float)ymlFiles.getDouble(String.valueOf(xyz) + ".yaw");
            loc.setPitch(pitchs);
            loc.setYaw(yaw);
        }
        return loc;
    }

    public static Location getYmlLocation(FileConfiguration ymlFiles, String xyz) {
        return Utils.getYmlLocation(ymlFiles, xyz, false);
    }

    public static void setYmlLocation(File yml, String xyz, Location loc, boolean pitch) {
        YamlConfiguration files = YamlConfiguration.loadConfiguration((File)yml);
        files.set(String.valueOf(xyz) + ".x", (Object)((double)loc.getBlockX() + 0.5));
        files.set(String.valueOf(xyz) + ".y", (Object)((double)loc.getBlockY() + 0.5));
        files.set(String.valueOf(xyz) + ".z", (Object)((double)loc.getBlockZ() + 0.5));
        if (pitch) {
            files.set(String.valueOf(xyz) + ".pitch", (Object)Float.valueOf(loc.getPitch()));
            files.set(String.valueOf(xyz) + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        }
        files.set(String.valueOf(xyz) + ".world", (Object)loc.getWorld().getName());
        try {
            files.save(yml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setYmlLocation(File yml, String xyz, Location loc) {
        Utils.setYmlLocation(yml, xyz, loc, false);
    }

    public static void setYmlInteger(File yml, String st, int in) {
        YamlConfiguration files = YamlConfiguration.loadConfiguration((File)yml);
        files.set(st, (Object)in);
        try {
            files.save(yml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setYmlString(File yml, String st, int stt) {
        YamlConfiguration files = YamlConfiguration.loadConfiguration((File)yml);
        files.set(st, (Object)stt);
        try {
            files.save(yml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setYmlLocationStringList(File yml, String st, Location loc) {
        YamlConfiguration files = YamlConfiguration.loadConfiguration((File)yml);
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        String w = loc.getWorld().getName();
        String put = String.valueOf(x) + "," + y + "," + z + "," + w;
        List<String> list = new ArrayList<String>();
        if (files.contains(st)) {
            list = files.getStringList(st);
        }
        list.add(put);
        files.set(st, list);
        try {
            files.save(yml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<Location> getYmlLocationStringList(File yml, String st) {
        YamlConfiguration files = YamlConfiguration.loadConfiguration((File)yml);
        ArrayList<Location> list = new ArrayList<Location>();
        List lists = files.getStringList(st);
        for (String str : lists) {
            String[] stra = str.split(",");
            int x = Integer.parseInt(stra[0]);
            int y = Integer.parseInt(stra[1]);
            int z = Integer.parseInt(stra[2]);
            String wd = stra[3];
            World w = Bukkit.getWorld((String)wd);
            list.add(new Location(w, (double)x, (double)y, (double)z));
        }
        return list;
    }

    public static void setConfigLocationStringList(String st, Location loc) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        String w = loc.getWorld().getName();
        String put = String.valueOf(x) + "," + y + "," + z + "," + w;
        List<String> list = new ArrayList<String>();
        if (Main.getInstance().getConfig().contains(st)) {
            list = Main.getInstance().getConfig().getStringList(st);
        }
        list.add(put);
        Main.getInstance().getConfig().set(st, list);
        Main.getInstance().saveConfig();
        Main.getInstance().reloadConfig();
    }

    public static List<Location> getConfigLocationStringList(String st) {
        ArrayList<Location> list = new ArrayList<Location>();
        List lists = Main.getInstance().getConfig().getStringList(st);
        for (String str : lists) {
            String[] stra = str.split(",");
            int x = Integer.parseInt(stra[0]);
            int y = Integer.parseInt(stra[1]);
            int z = Integer.parseInt(stra[2]);
            String wd = stra[3];
            World w = Bukkit.getWorld((String)wd);
            list.add(new Location(w, (double)x, (double)y, (double)z));
        }
        return list;
    }

    public static void sendActionBar(Player p, String message) {
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)message));
    }

    public static void sendTitle(Player target, String main, String sub) {
        target.sendTitle(main, sub, 20, 80, 20);
    }

    public static void sendTitle(String main, String sub) {
        for (Player target : Bukkit.getOnlinePlayers()) {
            Utils.sendTitle(target, main, sub);
        }
    }

    public static void removePotionEffects(Player p) {
        for (PotionEffect pe : p.getActivePotionEffects()) {
            p.removePotionEffect(pe.getType());
        }
    }

    public static void addPotionEffects(Player p, PotionEffectType potioneffecttype, int dur, int level, boolean particle) {
        p.addPotionEffect(new PotionEffect(potioneffecttype, dur, level, particle));
    }

    public static void addPotionEffects(Player p, PotionEffectType potioneffecttype, int dur, int level) {
        Utils.addPotionEffects(p, potioneffecttype, dur, level, false);
    }

    public static void soundToLocation(Location loc, Sound sound, float volume, float pitch) {
        loc.getWorld().playSound(loc, sound, SoundCategory.RECORDS, volume, pitch);
    }

    public static void soundToLocation(Location loc, Sound sound, float volume) {
        Utils.soundToLocation(loc, sound, volume, 1.0f);
    }

    public static void soundToLocation(Location loc, Sound sound) {
        Utils.soundToLocation(loc, sound, 1.0f, 1.0f);
    }

    public static void soundToLocation(Location loc, Sound sound, float volume, boolean randomPitch) {
        float pitch = rnd.nextInt(1) / 10;
        Utils.soundToLocation(loc, sound, volume, 1.0f + pitch);
    }

    public static void soundToLocation(Location loc, Sound sound, boolean randomPitch) {
        float pitch = rnd.nextInt(1) / 10;
        Utils.soundToLocation(loc, sound, 1.0f, 1.0f + pitch);
    }

    public static void soundToLocation(Location loc, String sound, float volume, float pitch) {
        loc.getWorld().playSound(loc, sound, SoundCategory.RECORDS, volume, pitch);
    }

    public static void soundToLocation(Location loc, String sound, float volume) {
        Utils.soundToLocation(loc, sound, volume, 1.0f);
    }

    public static void soundToLocation(Location loc, String sound) {
        Utils.soundToLocation(loc, sound, 1.0f, 1.0f);
    }

    public static void soundToLocation(Location loc, String sound, float volume, boolean randomPitch) {
        float pitch = rnd.nextInt(1) / 10;
        Utils.soundToLocation(loc, sound, volume, 1.0f + pitch);
    }

    public static void soundToLocation(Location loc, String sound, boolean randomPitch) {
        float pitch = rnd.nextInt(1) / 10;
        Utils.soundToLocation(loc, sound, 1.0f, 1.0f + pitch);
    }

    public static void soundToPlayer(Player p, Sound sound, float volume, float pitch) {
        p.playSound(p.getLocation(), sound, SoundCategory.RECORDS, volume, pitch);
    }

    public static void soundToPlayer(Player p, Sound sound, float volume) {
        Utils.soundToPlayer(p, sound, volume, 1.0f);
    }

    public static void soundToPlayer(Player p, Sound sound) {
        Utils.soundToPlayer(p, sound, 1.0f, 1.0f);
    }

    public static void soundToPlayer(Player p, Sound sound, float volume, boolean randomPitch) {
        float pitch = rnd.nextInt(1) / 10;
        Utils.soundToPlayer(p, sound, volume, 1.0f + pitch);
    }

    public static void soundToPlayer(Player p, Sound sound, boolean randomPitch) {
        float pitch = rnd.nextInt(1) / 10;
        Utils.soundToPlayer(p, sound, 1.0f, 1.0f + pitch);
    }

    public static void soundToPlayerAll(Sound sound) {
        for (Player a : Bukkit.getOnlinePlayers()) {
            Utils.soundToPlayer(a, sound);
        }
    }

    public static void soundToPlayer(Player p, String sound, float volume, float pitch) {
        p.playSound(p.getLocation(), sound, SoundCategory.RECORDS, volume, pitch);
    }

    public static void soundToPlayer(Player p, String sound, float volume) {
        Utils.soundToPlayer(p, sound, volume, 1.0f);
    }

    public static void soundToPlayer(Player p, String sound) {
        Utils.soundToPlayer(p, sound, 1.0f, 1.0f);
    }

    public static void soundToPlayer(Player p, String sound, float volume, boolean randomPitch) {
        float pitch = rnd.nextInt(1) / 10;
        Utils.soundToPlayer(p, sound, volume, 1.0f + pitch);
    }

    public static void soundToPlayer(Player p, String sound, boolean randomPitch) {
        float pitch = rnd.nextInt(1) / 10;
        Utils.soundToPlayer(p, sound, 1.0f, 1.0f + pitch);
    }

    public static void soundToPlayerAll(String sound) {
        for (Player a : Bukkit.getOnlinePlayers()) {
            Utils.soundToPlayer(a, sound);
        }
    }

    public static boolean checkExpiredNowDate(String name, Date expired) {
        try {
            Date now = Utils.nowTimeFormatDate(Utils.nowTimeFormatString());
            int i = expired.compareTo(now);
            return i == 0 || i == -1;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String nowTimeFormatString() {
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        SimpleDateFormat sdformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return sdformat.format(date);
    }

    public static String nowTimeFormatDateToString(Date date) {
        SimpleDateFormat sdformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return sdformat.format(date);
    }

    public static Date nowTimeFormatDate(String dateString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return sdf.parse(dateString);
    }

    public static void regionLocationSet(Location loc1, Location loc2, Material mat) {
        World w = loc1.getWorld();
        int minX = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int minY = Math.min(loc1.getBlockY(), loc2.getBlockY());
        int minZ = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int maxX = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int maxY = Math.max(loc1.getBlockY(), loc2.getBlockY());
        int maxZ = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        int x = minX;
        while (x <= maxX) {
            int y = minY;
            while (y <= maxY) {
                int z = minZ;
                while (z <= maxZ) {
                    Block block = w.getBlockAt(x, y, z);
                    block.setType(mat);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void registerEvent(Listener listener) {
        Main.getInstance().getServer().getPluginManager().registerEvents(listener, (Plugin)Main.getInstance());
    }

    public static void spawnParticle(Location loc, Particle particle, float offsetX, float offsetY, float offsetZ, int count, float speed) {
        loc.getWorld().spawnParticle(particle, loc, count, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed);
    }

    public static void Fireworks(Location loc, FireworkEffect.Type type, int power) {
        Random rnd = new Random();
        Firework fw = (Firework)loc.getWorld().spawnEntity(loc, EntityType.FIREWORK_ROCKET);
        FireworkMeta fwm = fw.getFireworkMeta();
        if (type == null) {
            type = FireworkEffect.Type.BALL;
        }
        int color = rnd.nextInt(17) + 1;
        int color2 = rnd.nextInt(17) + 1;
        Color c = Utils.getColor(color);
        Color c2 = Utils.getColor(color2);
        FireworkEffect effect = FireworkEffect.builder().flicker(rnd.nextBoolean()).withColor(c).withFade(c2).with(type).trail(rnd.nextBoolean()).build();
        fwm.addEffect(effect);
        fwm.setPower(power);
        fw.setFireworkMeta(fwm);
    }

    public static Color getColor(int i) {
        Color c = null;
        if (i == 1) {
            c = Color.AQUA;
        }
        if (i == 2) {
            c = Color.BLACK;
        }
        if (i == 3) {
            c = Color.BLUE;
        }
        if (i == 4) {
            c = Color.FUCHSIA;
        }
        if (i == 5) {
            c = Color.GRAY;
        }
        if (i == 6) {
            c = Color.GREEN;
        }
        if (i == 7) {
            c = Color.LIME;
        }
        if (i == 8) {
            c = Color.MAROON;
        }
        if (i == 9) {
            c = Color.NAVY;
        }
        if (i == 10) {
            c = Color.OLIVE;
        }
        if (i == 11) {
            c = Color.ORANGE;
        }
        if (i == 12) {
            c = Color.PURPLE;
        }
        if (i == 13) {
            c = Color.RED;
        }
        if (i == 14) {
            c = Color.SILVER;
        }
        if (i == 15) {
            c = Color.TEAL;
        }
        if (i == 16) {
            c = Color.WHITE;
        }
        if (i == 17) {
            c = Color.YELLOW;
        }
        return c;
    }
}

